<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class TheoryPackageResource extends JsonResource
{

    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'notes' => $this->notes,
            'photo' => $this->photo,
            'photo_extension' => $this->checkExtions($this->photo),
            'picture' => $this->picture,
            'picture_extension' => $this->checkExtions($this->picture),
            'coverPhone' => $this->coverPhone,
            'coverPhone_extension' => $this->checkExtions($this->coverPhone),
            'coverDesktop' => $this->coverDesktop,
            'coverDesktop_extension' => $this->checkExtions($this->coverDesktop),
            'color_border' => $this->color_border,
            'color_background' => $this->color_background,
            'show_in_home' => $this->show_in_home,
            'arrangement' => $this->arrangement,
            'price' => $this->price,
            'expiration_duration_in_dayes' => $this->expiration_duration_in_dayes,
            'enable' => $this->enable,
            'type_view' => $this->type_view,
            'arrangement_phone' => $this->arrangement_phone,
            'shortDesc' => $this->short_desc,
        ];
    }

    public function checkExtions($pro)
    {
        if ($pro != null) {
            $extension = pathinfo($pro, PATHINFO_EXTENSION);
            $imageExtensions = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
            if (in_array(pathinfo($pro, PATHINFO_EXTENSION), ["jpg", "jpeg", "gif", "png", "bmp", "webp", "PNG", "GIF", "JPG"]))
                return 'photo';

            return 'video';
        }

        return null;
    }
}
