<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class QuestionResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'question_uuid' => $this->question_uuid,
            'question' => $this->question,
            'exam_category_id' => $this->exam_category_id,
            'exam_id' => $this->exam_id,
            'question_type' => $this->question_type,
            'photo' => $this->photo,
            'photo_extension' => $this->checkExtions($this->photo),
            'arrangment' => $this->arrangment,
            'answerExplanation' => $this->answerExplanation,
            'answers' => $this->whenLoaded('answers', function () {
                return AnswerResource::collection($this->answers);
            }, null),
        ];
    }

    public function checkExtions($pro)
    {
        if ($pro != null) {
            $extension = pathinfo($pro, PATHINFO_EXTENSION);
            $imageExtensions = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
            if (in_array($extension, $imageExtensions)) {
                return 'photo';
            }
            return 'video';
        }
        return null;
    }
}
