<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ExamCategoryResource extends JsonResource
{

    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->categoryName,
            'description' => $this->description,
            'questions_num' => $this->questions_num,
            'exam_id' => $this->exam_id,
            'arrangment' => $this->arrangment,
            'duration_type' => $this->duration_type,
            'duration' => $this->duration,
            'explaination_while_exam' => $this->explaination_while_exam,
            'question_auto_move' => $this->question_auto_move,
            'wrong_question_to_fail' => $this->wrong_question_to_fail,
            'questions' =>  $this->whenLoaded('questions', function () {
                return QuestionResource::collection($this->questions);
            }, null),
        ];
    }
}
