<?php

namespace App\Http\Middleware;

use Closure;

class CountryMiddleware
{
    public function handle($request, Closure $next)
    {
        /* current country for user. we get this from the session + user table + has a default.
        * if the user changes the country while logged out it will change in the session
        * once the user log in we change the session to the user country in the DB
        * if changes the country while logged in it changes in the session + the DB
        */
        $countryService = app('country');


        // The below are to be shared across all the views
        view()->share('currentCountry', $countryService->getCurrentCountry());
        view()->share('availableCountries', $countryService->getAvailableCountries());

        return $next($request);
    }
}
