<?php

namespace App\Http\Middleware;

use Illuminate\Http\Request;
use Closure;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;

class ApiLanguageManager
{
    protected $supportedLanguages = ['ar', 'en', 'nl'];

    public function handle(Request $request, Closure $next)
    {
        $local = 'ar';

        // If user is logged in, use their preferred language
        if ($user = Auth::guard('api')->user()) {
            $local = $user->languageCode ?? 'ar';
        }
        // Otherwise, check the x-lang header (if provided)
        elseif ($request->hasHeader('x-lang')) {
            $headerLang = $request->header('x-lang');

            // Only use the header value if it's a supported language
            if (in_array($headerLang, $this->supportedLanguages, true)) {
                $local = $headerLang;
            }
        }

        // Set the application locale
        app()->setLocale($local);
        config(['app.fallback_locale' => $local]);

        return $next($request);
    }
}
