<?php

namespace App\Http\Controllers\Api\General;

use App\ApiResponse;
use App\Http\Controllers\Controller;
use App\Http\Resources\YoutubeVideoResource;
use App\Sys\Services\General\YoutubeVideoService;


class YoutubeVideoController extends Controller
{
    use ApiResponse;

    protected $youtubeVideoService;

    public function __construct(
        YoutubeVideoService $youtubeVideoService
    ) {
        $this->youtubeVideoService = $youtubeVideoService;
    }

    public function getSingleHomeVideo()
    {
        $response = $this->youtubeVideoService->getSingleHomeYoutubeVideo();

        if (! $response) {
            return $this->apiResponse(400, 'fail', null, null);
        }

        $video = new YoutubeVideoResource($response);

        return $this->apiResponse(200, 'success', null, $video);
    }
}
