<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Vimeo Fullscreen Loader</title>
    <style>
        * {
            box-sizing: border-box;
        }

        html,
        body {
            margin: 0;
            padding: 0;
            height: 100%;
            width: 100%;
        }

        #loader-wrapper {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: white;
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 9999;
        }

        .loader {
            border: 8px solid #f3f3f3;
            border-top: 8px solid #3498db;
            border-radius: 50%;
            width: 60px;
            height: 60px;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }

        body.loaded #loader-wrapper {
            display: none;
        }

        iframe {
            position: absolute;
            top: 0;
            left: 0;
            height: 100%;
            width: 100%;
            border: none;
        }
    </style>
</head>

<body>

    <!-- Loader -->
    <div id="loader-wrapper">
        <div class="loader"></div>
    </div>

    <!-- Fullscreen Vimeo iframe -->
    <iframe id="vimeo-player"
        src="https://player.vimeo.com/video/{{ $videoUrlCode }}?h=fa0bfaf0ed&amp;badge=0&amp;autopause=0&amp;player_id=0&amp;app_id=58479"
        allow="autoplay; fullscreen; picture-in-picture; clipboard-write; encrypted-media"></iframe>

    <script src="https://player.vimeo.com/api/player.js"></script>
    <script>
        const iframe = document.getElementById('vimeo-player');
        const player = new Vimeo.Player(iframe);

        player.ready().then(function() {
            document.body.classList.add('loaded');
        });
    </script>

</body>

</html>
