@extends('admin.layouts.main')
@section('content')
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="mr-auto">
                <h3 class="page-title">{{ trans('messages.add video') }}</h3>
            </div>
        </div>
    </div>
    <style>
        .bootstrap-tagsinput {
            width: 100%;
            padding: 0.6em;
        }
    </style>
    <section class="content">
        {!! Form::open(['route' => ['video.updatedProsec', $video->id], 'files' => true, 'id' => 'add-exam-form']) !!}
        <div class="row">
            <div class="col-lg-8 mx-auto">

                <div class="box">
                    <div class="box-body">
                        <!-- Nav tabs -->
                        <ul class="nav nav-tabs customtab2" role="tablist">
                            <li class="nav-item"><a class="nav-link active" data-toggle="tab" href="#home7"
                                    role="tab"><span class="hidden-sm-up"><i class="ion-home"></i></span> <span
                                        class="hidden-xs-down">{{ trans('messages.Arabic') }}</span></a></li>
                            <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#profile7" role="tab"><span
                                        class="hidden-sm-up"><i class="ion-person"></i></span> <span
                                        class="hidden-xs-down">{{ trans('messages.Netherland') }}</span></a></li>
                            <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#home8" role="tab"><span
                                        class="hidden-sm-up"><i class="ion-home"></i></span> <span
                                        class="hidden-xs-down">{{ trans('messages.English') }}</span></a></li>
                        </ul>

                        <!-- Tab panes -->
                        <div class="tab-content">
                            <div class="tab-pane active" id="home7" role="tabpanel">
                                <div class="p-15">
                                    <div class="row">
                                        <div class="col-md-6 form-group">
                                            <label for="name_ar">{{ trans('messages.Name Ar') }}
                                            </label>
                                            <div>
                                                {!! Form::text('name_ar', old('name_ar') != null ? old('name_ar') : $video->name_ar, [
                                                    'class' => 'form-control',
                                                    'placeholder' => trans('messages.Name Ar'),
                                                ]) !!}
                                            </div>
                                            @error('name_ar')
                                                <div class="badge badge-danger text-center" style="width: 100%">
                                                    {{ $message }}
                                                </div>
                                            @enderror
                                        </div>
                                        <div class="col-md-6 form-group">
                                            <label for="name_ar">{{ trans('messages.url_ar') }}
                                                (
                                                <span>id الفيديو باللغه العربيه</span>
                                                )
                                            </label>
                                            <div>
                                                {!! Form::text('url_ar', old('url_ar') != null ? old('url_ar') : $video->url_ar, [
                                                    'class' => 'form-control',
                                                    'placeholder' => '/1036327590',
                                                ]) !!}
                                            </div>
                                            @error('url_ar')
                                                <div class="badge badge-danger text-center" style="width: 100%">
                                                    {{ $message }}
                                                </div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="description_ar">{{ trans('messages.Description Ar') }}
                                        </label>
                                        <div>
                                            {!! Form::textarea('description_ar', old('description_ar') != null ? old('description_ar') : $video->desc_ar, [
                                                'id' => 'editor1',
                                                'class' => 'form-control',
                                                'placeholder' => trans('messages.Description Ar'),
                                            ]) !!}
                                        </div>
                                        @error('description_ar')
                                            <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                                            </div>
                                        @enderror
                                    </div>

                                </div>
                            </div>
                            <div class="tab-pane" id="home8" role="tabpanel">
                                <div class="p-15">
                                    <div class="row">
                                        <div class="col-md-6 form-group">
                                            <label for="name_en">{{ trans('messages.Name EN') }}
                                            </label>
                                            <div>
                                                {!! Form::text('name_en', old('name_en') != null ? old('name_en') : $video->name_en, [
                                                    'class' => 'form-control',
                                                    'placeholder' => trans('messages.Name EN'),
                                                ]) !!}
                                            </div>
                                            @error('name_en')
                                                <div class="badge badge-danger text-center" style="width: 100%">
                                                    {{ $message }}
                                                </div>
                                            @enderror
                                        </div>
                                        <div class="col-md-6 form-group">
                                            <label for="name_en">{{ trans('messages.url_en') }}
                                                (
                                                <span>id الفيديو باللغه العربيه</span>
                                                )
                                            </label>
                                            <div>
                                                {!! Form::text('url_en', old('url_en') != null ? old('url_en') : $video->url_en, [
                                                    'class' => 'form-control',
                                                    'placeholder' => '/1036327590',
                                                ]) !!}
                                            </div>
                                            @error('url_en')
                                                <div class="badge badge-danger text-center" style="width: 100%">
                                                    {{ $message }}
                                                </div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="description_en">{{ trans('messages.Description EN') }}
                                        </label>
                                        <div>
                                            {!! Form::textarea('description_en', old('description_en') != null ? old('description_en') : $video->desc_en, [
                                                'id' => 'editoren',
                                                'class' => 'form-control',
                                                'placeholder' => trans('messages.Description EN'),
                                            ]) !!}
                                        </div>
                                        @error('description_en')
                                            <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                                            </div>
                                        @enderror
                                    </div>

                                </div>
                            </div>
                            <div class="tab-pane" id="profile7" role="tabpanel">
                                <div class="p-15">
                                    <div class="row">
                                        <div class="col-md-6 form-group">
                                            <label for="name_nl">{{ trans('messages.Name Nl') }}
                                            </label>
                                            <div>
                                                {!! Form::text('name_nl', old('name_nl') != null ? old('name_nl') : $video->name_nl, [
                                                    'class' => 'form-control',
                                                    'placeholder' => trans('messages.Name Nl'),
                                                ]) !!}
                                            </div>
                                            @error('name_nl')
                                                <div class="badge badge-danger text-center" style="width: 100%">
                                                    {{ $message }}
                                                </div>
                                            @enderror
                                        </div>
                                        <div class="col-md-6 form-group">
                                            <label for="name_en">{{ trans('messages.url_ni') }}
                                                (
                                                <span>id الفيديو باللغه العربيه</span>
                                                )
                                            </label>
                                            <div>
                                                {!! Form::text('url_nl', old('url_nl') != null ? old('url_nl') : $video->url_nl, [
                                                    'class' => 'form-control',
                                                    'placeholder' => '/1036327590',
                                                ]) !!}
                                            </div>
                                            @error('url_ni')
                                                <div class="badge badge-danger text-center" style="width: 100%">
                                                    {{ $message }}
                                                </div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="description_nl">{{ trans('messages.Description Nl') }}
                                        </label>
                                        <div>
                                            {!! Form::textarea('description_nl', old('description_nl') != null ? old('description_nl') : $video->desc_nl, [
                                                'id' => 'editor2',
                                                'class' => 'form-control',
                                                'placeholder' => trans('messages.Description Nl'),
                                            ]) !!}
                                        </div>
                                        @error('description_nl')
                                            <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                                            </div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="form-group row">
                            <div class="col-lg-8 mx-auto">
                                <div class="custom-file-container">
                                    <div class="custom-file">
                                        <input type="file" name="image" class="custom-file-input" id="image">
                                        <label class="custom-file-label"
                                            for="image">{{ trans('messages.Image') }}</label>
                                    </div>
                                    <div class="bg-lightest p-10 rounded5 dvPreview text-center"
                                        style="width: 100%;margin-top: 1em;height: 10em;">
                                        @if (!empty($video->image) && file_exists(public_path() . '/' . $video->image))
                                            <img style="max-width: 100%;height: 100%;"
                                                src="{{ url('/' . $video->image) }}" alt="">
                                        @else
                                            <img style="max-width: 100%;height: 100%;"
                                                src="{{ url('/images/noimg.png') }}" alt="">
                                        @endif
                                    </div>
                                </div>
                                @error('image')
                                    <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                                    </div>
                                @enderror
                            </div>

                        </div>
                        <h2 class="panel-title">{{ trans('messages.Select Countries') }}</h2>
                        @foreach ($countries as $country)
                            @php
                                $columnName = 'country_' . $country->code;
                                $isChecked = isset($video->$columnName) && $video->$columnName == 1;
                            @endphp
                            <div class="checkbox">
                                <input type="checkbox" name="country_{{ $country->code }}"
                                    id="country_{{ $country->code }}" value="1"
                                    {{ $isChecked ? 'checked="checked"' : '' }} />
                                <label for="country_{{ $country->code }}">
                                    {{ $country->name }} ({{ $country->code }})
                                </label>
                            </div>
                        @endforeach
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer">
                        <button type="submit" class="btn btn-rounded btn-primary btn-outline">
                            <i class="ti-save-alt"></i> {{ trans('messages.Save') }}
                        </button>
                    </div>
                </div>
            </div>
        </div>
        {!! Form::Close() !!}
    </section>
@endsection


@section('script')
    <script type="text/javascript">
        $('.select2').select2();
        CKEDITOR.replace('editor1')
        CKEDITOR.replace('editoren')
        CKEDITOR.replace('editor2')
        $(document).ready(function() {
            $(window).keydown(function(event) {
                if (event.keyCode == 13) {
                    event.preventDefault();
                    return false;
                }
            });
        });
    </script>
@endsection
