    <style>
        .bootstrap-tagsinput {
            width: 100%;
            padding: 0.6em;
        }
    </style>
    <!-- Main content -->

    {!! Form::open(['route' => 'answer.store', 'files' => true, 'id' => 'add-answer-form']) !!}
    {!! Form::hidden('question_id', $question->id, []) !!}
    {!! Form::hidden('redirect_head', 'ajax_create', []) !!}
    {!! Form::hidden('redirect_body', sizeof($redirectArr) > 0 ? $redirectArr[0]['value'] : null, []) !!}

    <!-- Nav tabs -->
    <ul class="nav nav-tabs customtab2" role="tablist">
        <li class="nav-item"> <a class="nav-link active" data-toggle="tab" href="#home7" role="tab"><span
                    class="hidden-sm-up"><i class="ion-home"></i></span> <span
                    class="hidden-xs-down">{{ trans('messages.Arabic') }}</span></a> </li>
        <li class="nav-item"> <a class="nav-link" data-toggle="tab" href="#profile7" role="tab"><span
                    class="hidden-sm-up"><i class="ion-person"></i></span> <span
                    class="hidden-xs-down">{{ trans('messages.Netherland') }}</span></a> </li>
        <li class="nav-item"> <a class="nav-link" data-toggle="tab" href="#home8" role="tab"><span
                    class="hidden-sm-up"><i class="ion-person"></i></span> <span
                    class="hidden-xs-down">{{ trans('messages.Netherland') }}</span></a> </li>
    </ul>

    <!-- Tab panes -->
    <div class="tab-content">
        <div class="tab-pane active" id="home7" role="tabpanel">
            <div class="p-15">
                <div class="form-group">
                    <label for="answer_ar">{{ trans('messages.Answer Ar') }}
                    </label>
                    <div>
                        {!! Form::number('answer_ar', null, ['class' => 'form-control', 'placeholder' => trans('messages.Answer Ar')]) !!}
                    </div>
                    @error('answer_ar')
                        <div class="badge badge-danger text-center" style="width: 100%">
                            {{ $message }}
                        </div>
                    @enderror
                </div>
            </div>
        </div>
        <div class="tab-pane" id="home8" role="tabpanel">
            <div class="p-15">
                <div class="form-group">
                    <label for="answer_en">{{ trans('messages.Answer EN') }}
                    </label>
                    <div>
                        {!! Form::number('answer_en', null, ['class' => 'form-control', 'placeholder' => trans('messages.Answer EN')]) !!}
                    </div>
                    @error('answer_en')
                        <div class="badge badge-danger text-center" style="width: 100%">
                            {{ $message }}
                        </div>
                    @enderror
                </div>
            </div>
        </div>
        <div class="tab-pane" id="profile7" role="tabpanel">
            <div class="p-15">
                <div class="form-group">
                    <label for="answer_nl">{{ trans('messages.Answer Nl') }}
                    </label>
                    <div>
                        {!! Form::number('answer_nl', null, ['class' => 'form-control', 'placeholder' => trans('messages.Answer Nl')]) !!}
                    </div>
                    @error('answer_nl')
                        <div class="badge badge-danger text-center" style="width: 100%">
                            {{ $message }}
                        </div>
                    @enderror
                </div>
            </div>
        </div>
        <div class="form-group">
            <h2 class="panel-title">{{ trans('messages.Add country') }}</h2>
            @foreach ($countries as $country)
                <div class="checkbox">
                    <input type="checkbox" name="country_{{ $country->code }}" id="Checkbox_{{ $country->code }}"
                        value="1" {{ old('country_' . $country->code) ? 'checked' : '' }} />
                    <label for="Checkbox_{{ $country->code }}">{{ $country->name . '~' . $country->code }}</label>
                </div>
            @endforeach
        </div>
    </div>
    {!! Form::hidden('arrangment', 1, []) !!}
    <button type="submit" class="btn btn-rounded btn-primary btn-outline">
        <i class="ti-save-alt"></i> {{ trans('messages.Save') }}
    </button>

    {!! Form::Close() !!}


    <script type="text/javascript">
        $('#add-answer-form').on('submit', function(e) {
            e.preventDefault();
            var formData = new FormData(this);
            @foreach ($countries as $country)
                formData.delete('country_{{ $country->code }}');
                if ($("#Checkbox_{{ $country->code }}").is(":checked")) {
                    formData.append('country_{{ $country->code }}', '1');
                }
            @endforeach

            $.ajax({
                url: $(this).attr('action'),
                type: "POST",
                data: formData,
                success: function(msg) {
                    $("#exam-categories-section").html(msg);
                    $('#create-with-ajax').modal('hide');
                    window.location.reload();
                },
                error: function(xhr) {
                    var errors = $.parseJSON(xhr.responseText);
                    $.each(errors, function(key, value) {
                        if ($.isPlainObject(value)) {
                            $.each(value, function(k, v) {
                                $('#' + key + '-error').show().html(v);
                            });
                        }
                    });
                },
                cache: false,
                contentType: false,
                processData: false
            });
        });
    </script>
