<?php

namespace App\Sys\Services\Questions;

use App\Sys\Services;
use Illuminate\Support\Facades\Validator;
use App\Sys\Repositories\Questions\ReportQuestionRepository;

class ReportQuestionService extends Services
{
    protected $reportQuestionRepository;

    public function __construct(ReportQuestionRepository $reportQuestionRepository)
    {
        $this->reportQuestionRepository = $reportQuestionRepository;
    }

    public function storeReport($data, $userId)
    {
        $rules = [
            'exam_id' => ['required', 'integer', 'exists:exams,id'],
            'question_id' => ['required', 'integer', 'exists:questions,id'],
            'problem_type' => ['required', 'in:image_upload,lang_error,another_problem'],
            'problem_descreption' => ['nullable', 'string', 'max:3000'],
        ];

        $validator = Validator::make($data, $rules);

        if ($validator->fails()) {
            $this->setError($validator->errors());
            return false;
        }

        return $this->reportQuestionRepository->store($data, $userId);
    }
}
