<?php

namespace App\Sys\Services\Packages;

use App\Sys\Services;
use App\Sys\Repositories\Packages\PackageVideoRepository;

class PackageVideoService extends Services
{
    protected $packageVideoRepository;

    public function __construct(PackageVideoRepository $packageVideoRepository)
    {
        $this->packageVideoRepository = $packageVideoRepository;
    }

    public function getPackageVideoDetails($user)
    {
        $packageVideo = $this->packageVideoRepository->getActivePackageVideoSubscriptionByUserId($user);

        if (!$packageVideo) {
            return false;
        }

        return $packageVideo;
    }

    public function getActivePackages($limit)
    {
        $packageVideo = $this->packageVideoRepository->getActiveVideoPackages($limit);

        if (!$packageVideo) {
            return false;
        }

        return $packageVideo;
    }

    public function getVideosWithWatchProgress($user)
    {
        $packageVideoSubscription = $this->packageVideoRepository->getActivePackageVideoSubscriptionByUserId($user);

        if (! $packageVideoSubscription) {
            $this->setError('No active subscription');
            return false;
        }

        $videos = $this->packageVideoRepository->getVideosWithProgress($user, $packageVideoSubscription->package_id, $packageVideoSubscription->id);

        if (! $videos) {
            $this->setError('No available videos');
            return false;
        }

        return $videos;
    }

    public function getSelectedVideoById($user, $videoId)
    {
        $packageVideoSubscription = $this->packageVideoRepository->getActivePackageVideoSubscriptionByUserId($user);

        if (! $packageVideoSubscription) {
            $this->setError('No active subscription');
            return false;
        }

        $video = $this->packageVideoRepository->getVideoUsingIdWithProgress($user, $videoId,  $packageVideoSubscription->package_id);


        if (! $video) {
            $this->setError('Not available videos');
            return false;
        }

        $videoViews = $this->packageVideoRepository->getCurrentUserWatchCount($user, $videoId, $packageVideoSubscription->id);

        $videoShow = $videoViews->first();

        if ($videoShow && $videoShow->count_watch >= $packageVideoSubscription->one_count_play) {
            $this->setError('You have exceeded your permitted attempt');
            return false;
        }

        $this->packageVideoRepository->incrementWatchCount($user, $videoId, $packageVideoSubscription, $videoShow);

        if ($videoShow) {
            $videoShow->refresh();
        }

        return [
            'video' => $video,
            'videoShow' => $videoShow,
        ];
    }
}
