<?php

namespace App\Sys\Services\General;

use App\Sys\Repositories\General\StaticPageRepository;
use App\Sys\Services;

class StaticPageService extends Services
{
    protected $staticPageRepository;

    public function __construct(StaticPageRepository $staticPageRepository)
    {
        $this->staticPageRepository = $staticPageRepository;
    }
    public function staticContentOptions()
    {
        $response = $this->staticPageRepository->getStaticContent();

        if (!$response) {
            $this->setError('No content found');
            return false;
        }

        return $response;
    }

    public function staticContentSelectedOption($id)
    {
        $response = $this->staticPageRepository->getStaticContentById($id);

        if (!$response) {
            $this->setError('No content found');
            return false;
        }

        return $response;
    }
}
