<?php

namespace App\Sys\Services\Blogs;

use App\Sys\Repositories\Blogs\BlogRepository;
use Illuminate\Support\Facades\Validator;
use App\Sys\Services;

class BlogService  extends Services
{
    protected $blogRepository;

    public function __construct(BlogRepository $blogRepository)
    {
        $this->blogRepository = $blogRepository;
    }

    public function getBlogs($limit)
    {
        $blogs =  $this->blogRepository->getPaginatedBlogs($limit);

        if (! $blogs)
            return false;

        return $blogs;
    }

    public function getBlogById($blogId)
    {
        $blog =  $this->blogRepository->getSelectedBlog($blogId);

        if (! $blog) {
            $this->setError('blog not found');
            return false;
        }

        return $blog;
    }

    public function getBlogsByCategory($request, $limit)
    {
        $rules = [
            'category_id' => ['required', 'integer', 'exists:blog_categories,id'],
        ];

        $validator = Validator::make($request, $rules);

        if ($validator->fails()) {
            $this->setError($validator->errors());
            return false;
        }

        $blog =  $this->blogRepository->getPaginatedBlogsByCategoryId($request['category_id'], $limit);

        return $blog;
    }
}
