<?php

namespace App\Sys\Services\Blogs;

use App\Sys\Repositories\Blogs\BlogCategoryRepository;
use App\Sys\Services;

class BlogCategoryService extends Services
{
    protected $blogCategoryRepository;

    public function __construct(BlogCategoryRepository $blogCategoryRepository)
    {
        $this->blogCategoryRepository = $blogCategoryRepository;
    }

    public function getBlogCategories($limit)
    {
        $categories =  $this->blogCategoryRepository->getPaginatedBlogCategories($limit);

        if (! $categories)
            return false;

        return $categories;
    }
}
