<?php

namespace App\Sys\Repositories\Results;

use Carbon\Carbon;
use App\Models\Result;

class ProgressRepository
{
    public function getResultsForExams($user, $latestSubscriptionDate)
    {
        $formattedDate = Carbon::parse($latestSubscriptionDate)->Format('Y-d-m');

        return Result::where([
            ['user_id', $user->id],
            ['country_' . $user->countryCode, 1]
        ])
            ->whereDate('created_at', '>=', $formattedDate)
            ->with('exam')
            ->get();
    }
}
