<?php

namespace App\Sys\Repositories\Notifications;

use App\Models\Notification;
use App\Models\NotificationRead;

class NotificationRepository
{
    public function storeNotification($data)
    {
        $notification = new Notification();
        $notification->title = $data['title'];
        $notification->body = $data['body'];
        $notification->action = $data['action'];
        $notification->fcm_token = $data['fcm_token'] ?? null;
        $notification->user_id = $data['user_id'] ?? null;
        $notification->topic = $data['topic'] ?? null;
        return $notification->save();
    }

    public function getUserNotifications($user)
    {
        return Notification::where('user_id', $user->id)
            ->orWhere('topic', $user->countryCode)
            ->with(['notificationRead' => function ($query) use ($user) {
                $query->where('user_id', $user->id);
            }])
            ->latest()
            ->paginate(20);
    }

    public function markAsRead($notificationId, $user)
    {
        return NotificationRead::updateOrCreate(
            ['notification_id' => $notificationId, 'user_id' => $user->id],
        );
    }
}
