<?php

namespace App\Models;

use App\Traits\HasCountryTags;
use Illuminate\Support\Facades\App;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class YoutubeVideosController extends Model
{
    use HasFactory, HasCountryTags;
    protected $fillable = [
        'title_ar',
        'title_nl',
        'title_en',
        'country_ia',
        'country_sa',
        'country_ae',
        'description_ar',
        'description_nl',
        'description_en',
        'video_link',
        'enabel',
        'video_link_id',
        'video_type',
        'image',
        'is_phone_visible_home'
    ];

    protected $appends = [
        'title',
        'description',
        'photo'
    ];

    public function getTitleAttribute()
    {
        return $this->{'title_' . App::getLocale()} == null ? $this->name_ar : $this->{'title_' . App::getLocale()};
    }
    public function getDescriptionAttribute()
    {
        return $this->{'description_' . App::getLocale()} == null ? $this->name_ar : $this->{'description_' . App::getLocale()};
    }
    public function getPhotoAttribute()
    {
        return $this->image != null && file_exists(public_path() . '/' . $this->image) ? url('/' . $this->image) : null;
    }
}
