<?php

namespace App\Models;

use App\Traits\HasCountryTags;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PackageVideoSubscriptions extends Model
{
    use softDeletes, HasCountryTags;
    protected $table = 'package_video_subscriptions';

    public function user()
    {
        return $this->belongsTo('App\Models\User','user_id');
    }

    public function package()
    {
        return $this->belongsTo(PackageVideo::class, 'package_id');
    }
}
