<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FavoriteQuestion extends Model
{
    use HasFactory;

    protected $table = 'favorite_questions';

    protected $fillable = [
        'user_id',
        'question_id',
    ];

    public function question()
    {
        return $this->belongsTo(Question::class, 'question_id')->with('exam', 'answers');
    }
}
