<?php

namespace App\Http\Middleware;

use Illuminate\Http\Request;
use Closure;
use Illuminate\Support\Facades\Auth;

class ApiCountryManager
{
    protected $supportedCountries = ['ae', 'ia', 'sa'];

    public function handle(Request $request, Closure $next)
    {
        $country = 'sa';

        // If user is logged in, use their preferred country
        if ($user = Auth::guard('api')->user()) {
            $country = $user->countryCode ?? 'sa';
        }
        // Otherwise, check the x-country header (if provided)
        elseif ($request->hasHeader('x-country')) {
            $headerCountry = strtolower($request->header('x-country'));

            if (in_array($headerCountry, $this->supportedCountries, true)) {
                $country = $headerCountry;
            }
        }

        // this will be made in the run time only no need to add it to the config file
        config(['app.country' => $country]);

        return $next($request);
    }
}
