<?php

namespace App\Http\Controllers\Api\Questions;

use App\ApiResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Sys\Services\Questions\ReportQuestionService;

class ReportQuestionController extends Controller
{
    use ApiResponse;

    protected $reportQuestionService;

    public function __construct(ReportQuestionService $reportQuestionService)
    {
        $this->reportQuestionService = $reportQuestionService;
    }

    public function reportQuestion(Request $request)
    {
        $userId = Auth::guard('api')->user()->id;
        if ($this->reportQuestionService->storeReport($request->all(), $userId)) {
            return $this->apiResponse(200, 'Success', null, null);
        }

        $error = $this->reportQuestionService->errors();

        return $this->apiResponse(400, 'fail', $error, null);
    }
}
