<?php

namespace App\Http\Controllers\Admin;

use Validator;
use App\Models\Videos;
use App\Models\Country;
use App\Models\PackageVideo;
use Illuminate\Http\Request;
use App\Models\PackageVideoVideo;
use App\Models\PackageVideoOffers;
use Illuminate\Support\Facades\App;
use App\Http\Controllers\Controller;
use App\Models\PackageVideoSubscriptions;

class PackageVideoController extends Controller
{

    public function index(Request $request)
    {
        $sort_search = null;
        $countryCode = session('admin_country_code');
        $packages = PackageVideo::when($countryCode, function ($query) use ($countryCode) {
            return $query->where('country_' . $countryCode, 1);
        })->orderBy('created_at', 'desc');
        if ($request->has('search')) {
            $sort_search = $request->search;
            $packages = $packages->where('name_' . App::getLocale(), 'like', '%' . $sort_search . '%');
        }
        $packages = $packages->paginate(20);
        return view('admin.package_video.index', compact('packages', 'sort_search'));
    }

    public function create()
    {
        $videos = Videos::pluck('name_' . App::getLocale(), 'id');
        $countries = Country::all();
        return view('admin.package_video.create', compact('videos', 'countries'));
    }

    public function store(Request $request)
    {
        $validCountryCodes = Country::pluck('code')->toArray();

        $request->validate([
            'name_ar' => 'required',
            'notes_ar' => 'required',
            'price' => 'required',
            'videos' => 'required',
            'videos.*' => 'required',
            'expiration_duration_in_dayes' => 'required',
            'count_play_video' => 'required',
            'show_one_video' => 'required',
            "photo_phone" => "required|mimetypes:image/jpeg,image/png,image/jpg,image/gif,video/mp4,video/x-matroska,video/avi|max:5000",
            "photo_desktop" => "required|mimetypes:image/jpeg,image/png,image/jpg,image/gif,video/mp4,video/x-matroska,video/avi|max:5000",
            "cove_desktop_nl" => "required_if:type_view,photo|nullable|mimetypes:image/jpeg,image/png,image/jpg,image/gif,video/mp4,video/x-matroska,video/avi|max:5000",
            "cove_desktop_en" => "required_if:type_view,photo|nullable|mimetypes:image/jpeg,image/png,image/jpg,image/gif,video/mp4,video/x-matroska,video/avi|max:5000",
            "cove_desktop_ar" => "required_if:type_view,photo|nullable|mimetypes:image/jpeg,image/png,image/jpg,image/gif,video/mp4,video/x-matroska,video/avi|max:5000",
            "cove_phone_ar" => "required_if:type_view,photo|nullable|mimetypes:image/jpeg,image/png,image/jpg,image/gif,video/mp4,video/x-matroska,video/avi|max:5000",
            "cove_phone_nl" => "required_if:type_view,photo|nullable|mimetypes:image/jpeg,image/png,image/jpg,image/gif,video/mp4,video/x-matroska,video/avi|max:5000",
            "cove_phone_en" => "required_if:type_view,photo|nullable|mimetypes:image/jpeg,image/png,image/jpg,image/gif,video/mp4,video/x-matroska,video/avi|max:5000",
        ]);
        $package = new PackageVideo();
        if ($request->file('photo_desktop')) {
            $nameDesk =   saveFile($request->file('photo_desktop'), 'package');
            $package->photo_desktop = $nameDesk;
        }
        if ($request->file('photo_phone')) {
            $namePhone = saveFile($request->file('photo_phone'), 'package');
            $package->photo_phone = $namePhone;
        }
        if ($request->file('cove_phone_en')) {
            $namePhone = saveFile($request->file('cove_phone_en'), 'package');
            $package->cove_phone_en = $namePhone;
        }
        if ($request->file('cove_phone_nl')) {
            $namePhone = saveFile($request->file('cove_phone_nl'), 'package');
            $package->cove_phone_nl = $namePhone;
        }
        if ($request->file('cove_phone_ar')) {
            $namePhone = saveFile($request->file('cove_phone_ar'), 'package');
            $package->cove_phone_ar = $namePhone;
        }
        if ($request->file('cove_desktop_nl')) {
            $namePhone = saveFile($request->file('cove_desktop_nl'), 'package');
            $package->cove_desktop_nl = $namePhone;
        }
        if ($request->file('cove_desktop_en')) {
            $namePhone = saveFile($request->file('cove_desktop_en'), 'package');
            $package->cove_desktop_en = $namePhone;
        }
        if ($request->file('cove_desktop_ar')) {
            $namePhone = saveFile($request->file('cove_desktop_ar'), 'package');
            $package->cove_desktop_ar = $namePhone;
        }

        $package->type_view = $request->type_view;
        $package->name_ar = $request->name_ar;
        $package->name_en = $request->name_en;
        $package->name_nl = $request->name_nl;
        $package->notes_ar = $request->notes_ar;
        $package->notes_en = $request->notes_en;
        $package->notes_nl = $request->notes_nl;
        $package->price = $request->price;
        $package->expiration_duration_in_dayes = $request->expiration_duration_in_dayes;
        $package->count_play_video = $request->count_play_video;
        $package->show_one_video = $request->show_one_video;
        $package->badge_ar = $request->badge_ar;
        $package->badge_en = $request->badge_en;
        $package->badge_nl = $request->badge_nl;
        $package->arrangement = $request->arrangement;
        $package->color_background = $request->color_background;
        $package->color_border = $request->color_border;
        $package->active = ($request->active == 'on') ? true : false;
        $package->show_in_home = ($request->show_in_home == 'on') ? true : false;
        foreach ($validCountryCodes as $code) {
            $columnName = 'country_' . $code;
            $package->$columnName = $request->has('country_' . $code) ? 1 : 0;
        }
        $package->save();
        $package->save();
        $package->video()->sync($request->videos);
        $package->video_count = sizeof($request->videos);
        $package->save();
        session()->flash('notif', trans('messages.add_successfully'));
        return redirect()->route('package_video.index');
    }

    public function edit(PackageVideo $package)
    {
        $countries = Country::all();
        $videos = Videos::pluck('name_' . App::getLocale(), 'id');
        return view('admin.package_video.edit', compact('package', 'videos', 'countries'));
    }

    public function update(Request $request, PackageVideo $package)
    {
        $validCountryCodes = Country::pluck('code')->toArray();

        $request->validate([
            'name_ar' => 'required',
            'notes_ar' => 'required',
            'price' => 'required',
            'videos' => 'required',
            'videos.*' => 'required',
            'expiration_duration_in_dayes' => 'required',
            'count_play_video' => 'required',
            'show_one_video' => 'required',
            "photo_phone" => "nullable|mimetypes:image/jpeg,image/png,image/jpg,image/gif,video/mp4,video/x-matroska,video/avi|max:5000",
            "photo_desktop" => "nullable|mimetypes:image/jpeg,image/png,image/jpg,image/gif,video/mp4,video/x-matroska,video/avi|max:5000",
            "cove_desktop_nl" => "nullable|mimetypes:image/jpeg,image/png,image/jpg,image/gif,video/mp4,video/x-matroska,video/avi|max:5000",
            "cove_desktop_en" => "nullable|mimetypes:image/jpeg,image/png,image/jpg,image/gif,video/mp4,video/x-matroska,video/avi|max:5000",
            "cove_desktop_ar" => "nullable|mimetypes:image/jpeg,image/png,image/jpg,image/gif,video/mp4,video/x-matroska,video/avi|max:5000",
            "cove_phone_ar" => "nullable|mimetypes:image/jpeg,image/png,image/jpg,image/gif,video/mp4,video/x-matroska,video/avi|max:5000",
            "cove_phone_nl" => "nullable|mimetypes:image/jpeg,image/png,image/jpg,image/gif,video/mp4,video/x-matroska,video/avi|max:5000",
            "cove_phone_en" => "nullable|mimetypes:image/jpeg,image/png,image/jpg,image/gif,video/mp4,video/x-matroska,video/avi|max:5000",
        ]);

        if ($request->file('photo_desktop')) {
            $nameDesk =   saveFile($request->file('photo_desktop'), 'package');
            $package->photo_desktop = $nameDesk;
        }
        if ($request->file('photo_phone')) {
            $namePhone = saveFile($request->file('photo_phone'), 'package');
            $package->photo_phone = $namePhone;
        }
        if ($request->file('cove_phone_en')) {
            $namePhone = saveFile($request->file('cove_phone_en'), 'package');
            $package->cove_phone_en = $namePhone;
        }
        if ($request->file('cove_phone_nl')) {
            $namePhone = saveFile($request->file('cove_phone_nl'), 'package');
            $package->cove_phone_nl = $namePhone;
        }
        if ($request->file('cove_phone_ar')) {
            $namePhone = saveFile($request->file('cove_phone_ar'), 'package');
            $package->cove_phone_ar = $namePhone;
        }
        if ($request->file('cove_desktop_nl')) {
            $namePhone = saveFile($request->file('cove_desktop_nl'), 'package');
            $package->cove_desktop_nl = $namePhone;
        }
        if ($request->file('cove_desktop_en')) {
            $namePhone = saveFile($request->file('cove_desktop_en'), 'package');
            $package->cove_desktop_en = $namePhone;
        }
        if ($request->file('cove_desktop_ar')) {
            $namePhone = saveFile($request->file('cove_desktop_ar'), 'package');
            $package->cove_desktop_ar = $namePhone;
        }
        $package->type_view = $request->type_view;
        $package->name_ar = $request->name_ar;
        $package->name_en = $request->name_en;
        $package->name_nl = $request->name_nl;
        $package->notes_ar = $request->notes_ar;
        $package->notes_en = $request->notes_en;
        $package->notes_nl = $request->notes_nl;
        $package->price = $request->price;
        $package->expiration_duration_in_dayes = $request->expiration_duration_in_dayes;
        $package->count_play_video = $request->count_play_video;
        $package->show_one_video = $request->show_one_video;
        $package->badge_ar = $request->badge_ar;
        $package->badge_en = $request->badge_en;
        $package->badge_nl = $request->badge_nl;
        $package->arrangement = $request->arrangement;
        $package->show_in_home = ($request->show_in_home == 'on') ? true : false;
        $package->active = ($request->active == 'on') ? true : false;
        $package->video_count = PackageVideoVideo::where('package_id', $package->id)->count();
        $package->color_background = $request->color_background;
        $package->color_border = $request->color_border;
        foreach ($validCountryCodes as $code) {
            $columnName = 'country_' . $code;
            $package->$columnName = $request->has('country_' . $code) ? true : false;
        }
        $package->save();
        $package->video()->sync($request->videos);
        $package->video_count = sizeof($request->videos);
        $package->save();
        session()->flash('notif', trans('messages.updated_successfully'));
        return redirect()->route('package_video.index');
    }

    public function changeActive(Request $request)
    {
        $package = PackageVideo::find($request->id);
        if (!empty($package)) {
            $package->active =  $package->active == 1 ? 0 : 1;
            return $package->save();
        }
        return false;
    }

    public function destroy(PackageVideo $package)
    {
        $package->delete();
        session()->flash('notif', trans('messages.Package deleted successfully'));
        return redirect()->route('package_video.index');
    }



    //show
    public function showSubscrip($id)
    {
        $package = PackageVideo::find($id);
        if (!empty($package)) {
            $packageSub = PackageVideoSubscriptions::where('package_id', $id)->orderBy('updated_at', 'desc')->paginate(20);
            return view('admin.package_video.show', compact('packageSub', 'package'));
        }
        session()->flash('notif', trans('messages.NotFound'));
        return redirect()->back();
    }

    //destroy
    public function updatedSubscrib($id)
    {
        $sub = PackageVideoSubscriptions::find($id);
        if (!empty($sub)) {
            $sub->delete();
            session()->flash('notif', trans('messages.Package deleted successfully'));
            return redirect()->back();
        }
        return redirect()->back();
    }

    //edit
    public function subscripUpdated($id)
    {
        $countries = Country::all();

        $sub = PackageVideoSubscriptions::find($id);

        if (!empty($sub)) {
            return view('admin.package_video.updatedSub', compact('sub', 'countries'));
        }
        return redirect()->back();
    }

    //update
    public function updatedProcessSub(Request $request, $id)
    {
        $validCountryCodes = Country::pluck('code')->toArray();

        $subscription = PackageVideoSubscriptions::find($id);

        if (!empty($subscription)) {
            $subscription->expiration_date = $request->date;
            $subscription->count_play = $request->count_play;
            $subscription->one_count_play = $request->one_count_play;
            foreach ($validCountryCodes as $code) {
                $columnName = 'country_' . $code;
                $subscription->$columnName = $request->has('country_' . $code) ? true : false;
            }
            $subscription->save();
            session()->flash('notif', trans('messages.updated_successfully'));
            return redirect()->route('package_video.show', $subscription->package_id);
        }

        return redirect()->back();
    }

    public function getPackageOffers(Request $request)
    {
        $offers = PackageVideoOffers::where('package_id', $request->id)->pluck('title_' . App::getLocale(), 'id');
        return view('admin.package.partials.offers', compact('offers'));
    }

    public function getPackagePrice(Request $request)
    {
        return PackageVideo::find($request->id)->price;
    }
}
