<?php

namespace App\Http\Controllers\Admin;

use App\Models\Blog;

use App\Models\User;
use App\Models\Country;
use App\Mail\NewPassword;
use Illuminate\Support\Str;
use App\Models\BlogCategory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Http\Requests\StoreBlogRequest;
use App\Http\Requests\UpdateBlogRequest;

class BlogController extends Controller
{
    public function importNewUsers()
    {
        $clients = User::where('imported_user', true)->orderBy('id', 'ASC')->take(1)->get();
        foreach ($clients as $key => $value) {
            $randomString = Str::random(8);
            $client = User::where('id', $value->id)->first();
            $client->imported_user = 0;
            $client->password = Hash::make($randomString);
            $client->save();
            $data['name'] = $value->name;
            $data['email'] = $value->email;
            $data['message'] = 'Your new password to adnan eltaher aatheory is ' . $randomString;
            Mail::to($value->email)->send(new NewPassword($data));
        }

        return $clients;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $sort_search = null;
        $countryCode = session('admin_country_code');
        $blogs = Blog::when($countryCode, function ($query) use ($countryCode) {
            return $query->where('country_' . $countryCode, 1);
        })->orderBy('created_at', 'desc');
        if ($request->has('search')) {
            $sort_search = $request->search;
            $blogs = $blogs->where('title_' . App::getLocale(), 'like', '%' . $sort_search . '%');
        }
        $blogs = $blogs->paginate(20);
        return view('admin.Blog.index', compact('blogs', 'sort_search'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $categories = BlogCategory::pluck('name_' . App::getLocale(), 'id');

        $countries = Country::all();
        return view('admin.Blog.create', compact('categories', 'countries'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Http\Requests\StoreBlogRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreBlogRequest $request)
    {
        $validCountryCodes = Country::pluck('code')->toArray();
        $blog = new Blog;
        if ($request->file('image')) {
            $request->image = saveFile($request->file('image'), 'blog');
            $blog->image = $request->image;
        }
        $blog->title_ar = $request->title_ar;
        $blog->title_en = $request->title_en;
        $blog->slug_ar = $request->slug_ar;
        $blog->slug_en = $request->slug_en;
        $blog->title_nl = $request->title_nl;
        $blog->slug_nl = $request->slug_nl;
        $blog->tags_ar = $request->tags_ar;
        $blog->tags_en = $request->tags_en;
        $blog->tags_nl = $request->tags_nl;
        $blog->body_ar = $request->body_ar;
        $blog->body_en = $request->body_en;
        $blog->body_nl = $request->body_nl;
        $blog->description_ar = $request->description_ar;
        $blog->description_en = $request->description_en;
        $blog->description_nl = $request->description_nl;
        $blog->blog_category_id  = $request->blog_category_id;


        foreach ($validCountryCodes as $code) {
            $columnName = 'country_' . $code;
            $blog->$columnName = $request->has('country_' . $code) ? 1 : 0;
        }
        $blog->save();
        return redirect()->route('blog.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Blog  $blog
     * @return \Illuminate\Http\Response
     */
    public function show(Blog $blog)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Blog  $blog
     * @return \Illuminate\Http\Response
     */
    public function edit(Blog $blog)
    {
        $categories = BlogCategory::pluck('name_' . App::getLocale(), 'id');
        $countries = Country::all();
        return view('admin.Blog.edit', compact('blog', 'categories', 'countries'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdateBlogRequest  $request
     * @param  \App\Models\Blog  $blog
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateBlogRequest $request, Blog $blog)
    {
        $validCountryCodes = Country::pluck('code')->toArray();

        if ($request->file('image')) {
            $request->image = saveFile($request->file('image'), 'blog');
            $blog->image = $request->image;
        }
        $blog->title_ar = $request->title_ar;
        $blog->title_en = $request->title_en;
        $blog->slug_ar = $request->slug_ar;
        $blog->slug_en = $request->slug_en;
        $blog->title_nl = $request->title_nl;
        $blog->slug_nl = $request->slug_nl;
        $blog->tags_ar = $request->tags_ar;
        $blog->tags_en = $request->tags_en;
        $blog->tags_nl = $request->tags_nl;
        $blog->body_ar = $request->body_ar;
        $blog->body_en = $request->body_en;
        $blog->body_nl = $request->body_nl;
        $blog->description_ar = $request->description_ar;
        $blog->description_en = $request->description_en;
        $blog->description_nl = $request->description_nl;
        $blog->blog_category_id  = $request->blog_category_id;

        foreach ($validCountryCodes as $code) {
            $columnName = 'country_' . $code;
            $blog->$columnName = $request->has('country_' . $code) ? true : false;
        }

        $blog->save();
        return redirect()->route('blog.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Blog  $blog
     * @return \Illuminate\Http\Response
     */
    public function destroy(Blog $blog)
    {
        $blog->delete();
        session()->flash('notif', trans('messages.Blog deleted successfully'));
        return redirect()->route('blog.index');
    }
}
